// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ClientThread1.c
*
* DESCRIPTION:  This is client module ClientThread1.
*
\*****************************************************************************/

#include <stdio.h>
//++
#include <stdlib.h>
//++
#include <rt.h>
#include <string.h>

#include "MM_AandF.h"


void ClientThread1(void)
{
//+-
  RTHANDLE    hProcess;
  RTHANDLE    hShareMailbox;
  RTHANDLE    hOseg[NUM_MEM_ALLOCS];
  void *      pOseg[NUM_MEM_ALLOCS];
  void *      pCLibMem[NUM_MALLOCS];
//+-

//++
  int i;
  RTHANDLE  hMailBoxArray[NUM_MB_ALLOCS];
	RTHANDLE  rthCurrentProcessHandle;
 	POOLINFO  PoolInfoStruct;
  DWORD     dwBytesFreed;
//++

//--
#if 0
  // TODO: adjust process and mailbox name
  // TODO: remove the next lines if the object mailbox
  // was created in this process
  hProcess = LookupRtHandle(hRootProcess, "OMBX_OWNER", WAIT_FOREVER);
  if (hProcess == BAD_RTHANDLE)
    Fail("Cannot find object mailbox process");

  // TODO: replace hProcess by NULL_RTHANDLE
  // if the object mailbox was created in this process
  hOmbx = LookupRtHandle(hProcess, "OMBX_NAME", WAIT_FOREVER);
  if (hOmbx == BAD_RTHANDLE)
    Fail("Cannot find object mailbox");
#endif
//--

//++
  // Allocate Object Mailboxes
  printf("Allocating object mailboxes\n\n");

  // Create and catalog object mailbox for memory handle sharing
  if ( (hShareMailbox = CreateRtMailbox(OBJECT_MAILBOX | FIFO_QUEUING | MAILBOX_DEPTH(8))) != BAD_RTHANDLE)
  {
    if (!Catalog(hRootProcess, hShareMailbox, "SHARED_MB"))
    {
      printf("Catalog sharing mailbox failed\n");
    }
    else
    {
      // Start MB_Pong process
      hProcess = CreateRtProcess("C:\\INtime\\Projects\\MM_Share\\MM_Share\\Debug\\MM_Share.rta",
			      NULL, NULL, PROC_EXECUTABLE_DS);
      if (hProcess == BAD_RTHANDLE)
      {
        Fail("MB_Pong CreateRtProcess failed!\r\n");
      }
    }
  }
  else
  {
    printf("CreateRtMailbox for memory sharing failed\n");
  }

	if ( (rthCurrentProcessHandle = GetRtThreadHandles(THIS_PROCESS)) != (RTHANDLE) NULL )
	{

	  if ( GetRtProcessPoolInfo(rthCurrentProcessHandle, &PoolInfoStruct) )
	  {
      printf("Starting object MB allocation for-loop\n");
		  printf("Memory Pool Original Size:\t%u (%uK)\n", PoolInfoStruct.cbInitialSize, (PoolInfoStruct.cbInitialSize/1024));
		  printf("Memory Pool Minimum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMin, (PoolInfoStruct.cbPoolMin/1024));
		  printf("Memory Pool Maximum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMax, (PoolInfoStruct.cbPoolMax/1024));
		  printf("Memory Pool Allocated\t\t%u (%uK)\n", PoolInfoStruct.cbAllocated, (PoolInfoStruct.cbAllocated/1024));
		  printf("Memory Pool Available\t\t%u (%uK)\n", PoolInfoStruct.cbAvailable, (PoolInfoStruct.cbAvailable/1024));
		  printf("Memory Pool Borrowed\t\t%u (%uK)\n\n", PoolInfoStruct.cbBorrowed, (PoolInfoStruct.cbBorrowed/1024));
	  }
	  else
	  {
		  printf("GetRtProcessPoolInfo failed!\n");
	  }

    for (i = 0; i < NUM_MB_ALLOCS; i++)
    {
      if ( (hMailBoxArray[i] = CreateRtMailbox(OBJECT_MAILBOX | FIFO_QUEUING | MAILBOX_DEPTH(8))) == BAD_RTHANDLE)
      {
        printf("Object mailbox creation failed on number: %d\n", i);
        break;
      }
      else
      {
				  if ( GetRtProcessPoolInfo(rthCurrentProcessHandle, &PoolInfoStruct) )
				  {
            printf("Object MB allocation %d\n", i);
					  printf("Memory Pool Original Size:\t%u (%uK)\n", PoolInfoStruct.cbInitialSize, (PoolInfoStruct.cbInitialSize/1024));
					  printf("Memory Pool Minimum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMin, (PoolInfoStruct.cbPoolMin/1024));
					  printf("Memory Pool Maximum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMax, (PoolInfoStruct.cbPoolMax/1024));
					  printf("Memory Pool Allocated\t\t%u (%uK)\n", PoolInfoStruct.cbAllocated, (PoolInfoStruct.cbAllocated/1024));
					  printf("Memory Pool Available\t\t%u (%uK)\n", PoolInfoStruct.cbAvailable, (PoolInfoStruct.cbAvailable/1024));
					  printf("Memory Pool Borrowed\t\t%u (%uK)\n\n", PoolInfoStruct.cbBorrowed, (PoolInfoStruct.cbBorrowed/1024));
				  }
				  else
				  {
            printf("GetRtProcessPoolInfo failed on iteration: %d!\n\n", i);
					  break;
				  }
      }
    }

    //Delete object mailboxes
    printf("\nDeleting object mailboxes\n\n");

    for (i = 0; i < NUM_MB_ALLOCS; i++)
    {
      if (DeleteRtMailbox(hMailBoxArray[i]))
      {
				  if ( GetRtProcessPoolInfo(rthCurrentProcessHandle, &PoolInfoStruct) )
				  {
            printf("Object MB deletion %d\n", i);
					  printf("Memory Pool Original Size:\t%u (%uK)\n", PoolInfoStruct.cbInitialSize, (PoolInfoStruct.cbInitialSize/1024));
					  printf("Memory Pool Minimum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMin, (PoolInfoStruct.cbPoolMin/1024));
					  printf("Memory Pool Maximum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMax, (PoolInfoStruct.cbPoolMax/1024));
					  printf("Memory Pool Allocated\t\t%u (%uK)\n", PoolInfoStruct.cbAllocated, (PoolInfoStruct.cbAllocated/1024));
					  printf("Memory Pool Available\t\t%u (%uK)\n", PoolInfoStruct.cbAvailable, (PoolInfoStruct.cbAvailable/1024));
					  printf("Memory Pool Borrowed\t\t%u (%uK)\n\n", PoolInfoStruct.cbBorrowed, (PoolInfoStruct.cbBorrowed/1024));
				  }
				  else
				  {
            printf("GetRtProcessPoolInfo failed on iteration: %d!\n\n", i);
					  break;
				  }
      }
      else
      {
        printf("Objection mailbox deletion failed on number: %d\n", i);
        break;
      }
    }

  }
  else
  {
	  printf("GetRtThreadHandles failed to return current process handle!\n");
  }
//++

//+-
  //Allocate shared memory buffer
  printf("\nAllocating shared memory buffer\n");

//  while (1)
  for (i = 0; i < NUM_MEM_ALLOCS; i++)
  {
    // TODO: put client code that must be repeated here
    // the RtSleep call is just an example
//    RtSleep(1000);

    // size of segment must be a multiple of 4096
    if ( (pOseg[i] = AllocateRtMemory(4096)) == NULL)
    {
//    if (pOseg == NULL)
      printf("Shared memory allocation failed on number: %d\n", i);
      break;
    }
    else
    {
      if ( (hOseg[i] = CreateRtMemoryHandle(pOseg[i], 4096)) != BAD_RTHANDLE )
      {
        // Mail memory handle
        if (!SendRtHandle(hShareMailbox, hOseg[i], NULL_RTHANDLE))
        {
          printf("SendRtHandle failed on %d\n");
          break;
        }
      }
      else
      {
        printf("CreateRtMemoryHandle failed on %d\n", i);
        break;
      }

	    if ( GetRtProcessPoolInfo(rthCurrentProcessHandle, &PoolInfoStruct) )
	    {
        printf("Memory allocation %d\n", i);
		    printf("Memory Pool Original Size:\t%u (%uK)\n", PoolInfoStruct.cbInitialSize, (PoolInfoStruct.cbInitialSize/1024));
		    printf("Memory Pool Minimum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMin, (PoolInfoStruct.cbPoolMin/1024));
		    printf("Memory Pool Maximum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMax, (PoolInfoStruct.cbPoolMax/1024));
		    printf("Memory Pool Allocated\t\t%u (%uK)\n", PoolInfoStruct.cbAllocated, (PoolInfoStruct.cbAllocated/1024));
		    printf("Memory Pool Available\t\t%u (%uK)\n", PoolInfoStruct.cbAvailable, (PoolInfoStruct.cbAvailable/1024));
		    printf("Memory Pool Borrowed\t\t%u (%uK)\n\n", PoolInfoStruct.cbBorrowed, (PoolInfoStruct.cbBorrowed/1024));
	    }
	    else
	    {
        printf("GetRtProcessPoolInfo failed on iteration: %d!\n\n", i);
		    break;
	    }
#if 0
      strcpy(pOseg, "1234");
      hOseg = CreateRtMemoryHandle(pOseg, 4096);
      if (hOseg == BAD_RTHANDLE)
        Fail("Cannot create memory handle for object mailbox");
      if (!SendRtHandle(hOmbx, hOseg, NULL_RTHANDLE))
        Fail("Cannot send to object mailbox");
#endif

    }

  }

  //Free RT memory
  printf("\nFreeing shared memory buffer\n");

  for (i = 0; i < NUM_MEM_ALLOCS; i++)
  {
    if ((dwBytesFreed = FreeRtMemory(pOseg[i])) < 0)
    {
      printf("Memory free failed on number: %d\n", i);
      break;
    }
    else
    {
	    if ( GetRtProcessPoolInfo(rthCurrentProcessHandle, &PoolInfoStruct) )
	    {
        printf("Memory free %d, freed %d bytes\n", i, dwBytesFreed);
		    printf("Memory Pool Original Size:\t%u (%uK)\n", PoolInfoStruct.cbInitialSize, (PoolInfoStruct.cbInitialSize/1024));
		    printf("Memory Pool Minimum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMin, (PoolInfoStruct.cbPoolMin/1024));
		    printf("Memory Pool Maximum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMax, (PoolInfoStruct.cbPoolMax/1024));
		    printf("Memory Pool Allocated\t\t%u (%uK)\n", PoolInfoStruct.cbAllocated, (PoolInfoStruct.cbAllocated/1024));
		    printf("Memory Pool Available\t\t%u (%uK)\n", PoolInfoStruct.cbAvailable, (PoolInfoStruct.cbAvailable/1024));
		    printf("Memory Pool Borrowed\t\t%u (%uK)\n\n", PoolInfoStruct.cbBorrowed, (PoolInfoStruct.cbBorrowed/1024));
	    }
	    else
	    {
        printf("GetRtProcessPoolInfo failed on iteration: %d!\n\n", i);
		    break;
	    }
    }
  }

  // Start Malloc sequence
  printf("Starting malloc series\n");

  for (i = 0; i < NUM_MALLOCS; i++)
  {
    if ( (pCLibMem[i] = malloc(1024)) != NULL )
    {
	    if ( GetRtProcessPoolInfo(rthCurrentProcessHandle, &PoolInfoStruct) )
	    {
        printf("C Library malloc %d\n", i);
		    printf("Memory Pool Original Size:\t%u (%uK)\n", PoolInfoStruct.cbInitialSize, (PoolInfoStruct.cbInitialSize/1024));
		    printf("Memory Pool Minimum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMin, (PoolInfoStruct.cbPoolMin/1024));
		    printf("Memory Pool Maximum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMax, (PoolInfoStruct.cbPoolMax/1024));
		    printf("Memory Pool Allocated\t\t%u (%uK)\n", PoolInfoStruct.cbAllocated, (PoolInfoStruct.cbAllocated/1024));
		    printf("Memory Pool Available\t\t%u (%uK)\n", PoolInfoStruct.cbAvailable, (PoolInfoStruct.cbAvailable/1024));
		    printf("Memory Pool Borrowed\t\t%u (%uK)\n\n", PoolInfoStruct.cbBorrowed, (PoolInfoStruct.cbBorrowed/1024));
	    }
	    else
	    {
        printf("GetRtProcessPoolInfo failed on iteration: %d!\n\n", i);
		    break;
	    }
    }
    else
    {
      printf("malloc failed on number: %d\n", i);
      break;
    }
  }

  //Free malloc'd memory
  printf("Starting free sequence for malloc\'d memory\n");

  for (i = 0; i < NUM_MALLOCS; i++)
  {
    free(pCLibMem[i]);

    if ( GetRtProcessPoolInfo(rthCurrentProcessHandle, &PoolInfoStruct) )
    {
      printf("C Library free %d\n", i);
	    printf("Memory Pool Original Size:\t%u (%uK)\n", PoolInfoStruct.cbInitialSize, (PoolInfoStruct.cbInitialSize/1024));
	    printf("Memory Pool Minimum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMin, (PoolInfoStruct.cbPoolMin/1024));
	    printf("Memory Pool Maximum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMax, (PoolInfoStruct.cbPoolMax/1024));
	    printf("Memory Pool Allocated\t\t%u (%uK)\n", PoolInfoStruct.cbAllocated, (PoolInfoStruct.cbAllocated/1024));
	    printf("Memory Pool Available\t\t%u (%uK)\n", PoolInfoStruct.cbAvailable, (PoolInfoStruct.cbAvailable/1024));
	    printf("Memory Pool Borrowed\t\t%u (%uK)\n\n", PoolInfoStruct.cbBorrowed, (PoolInfoStruct.cbBorrowed/1024));
    }
    else
    {
      printf("GetRtProcessPoolInfo failed on iteration: %d!\n\n", i);
	    break;
    }
  }

  printf("Exiting\n");

// Delete memory share process
  if (!DeleteRtProcess(hProcess,0))
  {
    printf("Failed to delete memory share process\n");
  }

  ExitRtProcess();
//+-
}
